/*  Metrowerks Standard Library  */

/*  $Date: 2000/05/16 16:37:41 $ 
 *  $Revision: 1.2.18.2 $ 
 *  $NoKeywords: $ 
 *
 *		Copyright  1995-1999 Metrowerks, Inc.
 *		All rights reserved.
 */
 
/*
 *	stdint.h
 *
 *  based on the C99 Standard
 *
*/

#ifndef _STDINT_H
#define _STDINT_H

#include <cstdint>

#if defined(__cplusplus) && defined(_MSL_USING_NAMESPACE)
	using std::int8_t;
	using std::int16_t;
	using std::int32_t;
	using std::uint8_t;
	using std::uint16_t;
	using std::uint32_t;
	using std::int_least8_t;
	using std::int_least16_t;
	using std::int_least32_t;
	using std::uint_least8_t;
	using std::uint_least16_t;
	using std::uint_least32_t;
	using std::int_fast8_t;
	using std::int_fast16_t;
	using std::int_fast32_t;
	using std::uint_fast8_t;
	using std::uint_fast16_t;
	using std::uint_fast32_t;
#ifdef __MSL_LONGLONG_SUPPORT__
	using std::int64_t;
	using std::uint64_t;
	using std::int_least64_t;
	using std::uint_least64_t;
	using std::int_fast64_t;
	using std::uint_fast64_t;
#endif
	using std::intptr_t;
	using std::uintptr_t;
	using std::intmax_t;
	using std::uintmax_t;
#endif

#endif

/*
 * Change record
 * blc 990323 Created.
 * hh 991113   Fixed using bug.
 * mm 000512   Updated to C99 Standard
*/
