/*
ADOBE SYSTEMS INCORPORATED
Copyright 1994 - 2007 Adobe Macromedia Software LLC
All Rights Reserved

NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the 
terms of the Adobe license agreement accompanying it.  If you have received this file from a 
source other than Adobe, then your use, modification, or distribution of it requires the prior 
written permission of Adobe.
*/


#define INITGUID 1

#include "script.h"

#include <string.h>
#include <stdlib.h>
#include "xclassver.h"
#include "moatry.h"

#include "driservc.h"
#include "drivalue.h"

#include "mmivalue.h"
#include "mmillist.h"
#include "mmiplist.h"
#include "mmidate.h"
#include "mmiclr.h"
 
 /* This is the list of handlers for the xtra. The versionInfo string is combined
 /*	with the msgTable string in the register method to create a single string that
 /* used when registering the xtra as a scripting xtra. */

static char versionInfo[] = "xtra useDll -- version %s.%s.%s\n";
static char msgTable[] = { 
	"* negate integer -- negates a number\n"
	"* sum3 integer, integer, integer -- sums 3 numbers\n"
	"* setBitD value, bitnum -- sets bit in a value\n" 
	};

/* 	This is the enumerated scripting method list. This list should
 *	directly correspond to the msgTable defined above. It is used
 *	to dispatch method calls via the methodSelector. The 'm_XXXX' method must
 *	be last.
 */

enum 
{
	m_negateHandler,						
	m_sum3Handler,
	m_setbitHandler,
	m_XXXX
};

/* ============================================================================= */
/* Xtra Glue Stuff */
/* ============================================================================= */

#define XTRA_VERSION_NUMBER XTRA_CLASS_VERSION

BEGIN_XTRA
	BEGIN_XTRA_DEFINES_CLASS(TStdXtra, XTRA_CLASS_VERSION)
		CLASS_DEFINES_INTERFACE(TStdXtra, IMoaRegister, XTRA_VERSION_NUMBER)
		CLASS_DEFINES_INTERFACE(TStdXtra, IMoaMmXScript, XTRA_VERSION_NUMBER)
	END_XTRA_DEFINES_CLASS
END_XTRA


/* ============================================================================= */
/* Create/Destroy for class TStdXtra */
/* ============================================================================= */

STDMETHODIMP_(MoaError) MoaCreate_TStdXtra (TStdXtra FAR * This)
{
moa_try
		
	ThrowErr (This->pCallback->QueryInterface(&IID_IMoaMmValue, (PPMoaVoid) &This->pValueInterface));
	ThrowErr (This->pCallback->QueryInterface(&IID_IMoaMmUtils2, (PPMoaVoid) &This->pMoaUtils));
	
moa_catch
moa_catch_end
moa_try_end
}

STDMETHODIMP_(void) MoaDestroy_TStdXtra(TStdXtra FAR * This)
{
moa_try

	if (This->pValueInterface != NULL) 
		ThrowErr (This->pValueInterface->Release());
	if (This->pMoaUtils != NULL) 
		ThrowErr (This->pMoaUtils->Release());

moa_catch
moa_catch_end
moa_try_end_void
}


/* ============================================================================= */
/* Methods in TStdXtra_IMoaRegister */
/* ============================================================================= */

/*****************************************************************************
 *  Data needed for Registering
 *	---------------------------
 *	Specific code needed to register different types of Xtras.  The skeleton
 *	source files include minimal implementations appropriate for each Xtra
 *	type.  Current necessary actions:
 *
 *	Scripting Xtra:				Add the Scripting Xtra Message Table
 *	Sprite Asset Xtra:			Nothing
 *	Tool Xtra:					Nothing
 *	Transition Asset Xtra		Nothing
 *
 *  ****optional: Register as Safe for Shockwave!
 *****************************************************************************/ 

STD_INTERFACE_CREATE_DESTROY(TStdXtra, IMoaRegister)

BEGIN_DEFINE_CLASS_INTERFACE(TStdXtra, IMoaRegister)
END_DEFINE_CLASS_INTERFACE

/* ----------------------------------------------------------------------------- */
STDMETHODIMP TStdXtra_IMoaRegister::Register(
	PIMoaCache pCache, 
	PIMoaXtraEntryDict pXtraDict
)
{	
moa_try
	PIMoaRegistryEntryDict pReg;
	MoaBool bItsSafe = FALSE;
	char versionStr[256];
	PMoaVoid pMemStr = NULL;

	/* Register the lingo xtra */
	ThrowErr(pCache->AddRegistryEntry(pXtraDict, &CLSID_TStdXtra, &IID_IMoaMmXScript, &pReg));

	/* Register the method table */
	sprintf(versionStr, versionInfo, VER_MAJORVERSION_STRING, VER_MINORVERSION_STRING, VER_BUGFIXVERSION_STRING);
	pMemStr = pObj->pCalloc->NRAlloc(sizeof(msgTable) + sizeof(versionStr));
	ThrowNull(pMemStr);

	strcpy((char *)pMemStr, versionStr);
	strcat((char *)pMemStr, msgTable);
	ThrowErr(pReg->Put(kMoaDrDictType_MessageTable, pMemStr, 0, kMoaDrDictKey_MessageTable));

	/* Mark xtra as safe for shockwave - but only if it IS safe !
	/  I know that sampleDll.dll is safe, since i wrote it myself
	/  But i do not know for sure if binaryLib.dll is safe - it is just a free-ware DLL i found on the web */
	/*
	ThrowErr(pReg->Put(kMoaMmDictType_SafeForShockwave, &bItsSafe, sizeof(bItsSafe), kMoaMmDictKey_SafeForShockwave));
	*/

moa_catch
moa_catch_end
	if (pMemStr)
		pObj->pCalloc->NRFree(pMemStr);
moa_try_end
}

/* ============================================================================= */
/*  Methods in TStdXtra_IMoaMmXScript */
/* ============================================================================= */

BEGIN_DEFINE_CLASS_INTERFACE(TStdXtra, IMoaMmXScript)
END_DEFINE_CLASS_INTERFACE

//******************************************************************************
TStdXtra_IMoaMmXScript::TStdXtra_IMoaMmXScript(MoaError FAR * pError)
//------------------------------------------------------------------------------
{
	*pError = kMoaErr_NoErr;
}	

//******************************************************************************
TStdXtra_IMoaMmXScript::~TStdXtra_IMoaMmXScript()
//------------------------------------------------------------------------------
{
}

/* ----------------------------------------------------------------------------- */
STDMETHODIMP TStdXtra_IMoaMmXScript::Call (PMoaDrCallInfo callPtr)
{
moa_try
	switch	( callPtr->methodSelector ) 
	{
		case m_negateHandler:
			ThrowErr(NegateHandler(callPtr));
			break;
		case m_sum3Handler:
			ThrowErr(Sum3Handler(callPtr));
			break;
		case m_setbitHandler:
			ThrowErr(SetBitHandler(callPtr));
			break;
	}
moa_catch
moa_catch_end
moa_try_end
}

/*****************************************************************************
 *  Private Methods
 *  -------------------
 *  Implementation of Private Class Methods
 /*
 *  This is the actual code for the defined methods. They are defined as 
 *  functions, and called from the switch statement in Call().
 *
 ****************************************************************************/

/* ----------------------------------------------------- NegateHandler */
MoaError TStdXtra_IMoaMmXScript::NegateHandler(PMoaDrCallInfo pCall)
{
moa_try
	
	MoaChar pathBuff[MAX_PATH];
#ifdef _DEBUG
	ThrowErr(pObj->pMoaUtils->PrintMessage("NegateHandler called\n"));
#endif
	GetDllPath(pathBuff, "SampleDLL.dll");
	HMODULE hm = LoadLibrary(pathBuff);
	if (hm==NULL)
	{
#ifdef _DEBUG
		pObj->pMoaUtils->PrintMessage("SampleDLL not found\n");
#endif
		Throw(kMoaErr_FileNotFound);
	}
	typedef void (__cdecl *negateproc)(int * a);
	negateproc fp = (negateproc)GetProcAddress(hm, "negate");
	if (fp)
	{
		MoaMmValue argValue;
		MoaLong num;
		int mynum;
		pciGetArgByIndex( pCall, 1, &argValue );
		ThrowErr (pObj->pValueInterface->ValueToInteger(&argValue, &num));
		mynum = num;
		(fp)(&mynum); // call the function in the DLL
		ThrowErr(pObj->pValueInterface->IntegerToValue(mynum, &pCall->resultValue));
		FreeLibrary(hm);
	}
	else
	{
#ifdef _DEBUG
		pObj->pMoaUtils->PrintMessage("negate procedure not found\n");
#endif
		FreeLibrary(hm);
		Throw(kMoaErr_FuncNotFound);
	}

moa_catch
moa_catch_end	
moa_try_end	
}

/* ----------------------------------------------------- Sum3Handler */
MoaError TStdXtra_IMoaMmXScript::Sum3Handler(PMoaDrCallInfo pCall)
{	
moa_try

	MoaChar pathBuff[MAX_PATH];
#ifdef _DEBUG
	ThrowErr(pObj->pMoaUtils->PrintMessage("Sum3Handler called\n"));
#endif
	GetDllPath(pathBuff, "SampleDLL.dll");
	HMODULE hm = LoadLibrary(pathBuff);
	if (hm==NULL)
	{
#ifdef _DEBUG
		pObj->pMoaUtils->PrintMessage("SampleDLL not found\n");
#endif
		Throw(kMoaErr_FileNotFound);
	}

	typedef int (__cdecl *sum3proc)(int a, int b, int c);
	sum3proc fp = (sum3proc)GetProcAddress(hm, "sum3");
	if (fp)
	{
		MoaMmValue argValue;
		MoaLong num1, num2, num3;
		int mynum;
		pciGetArgByIndex( pCall, 1, &argValue );
		ThrowErr (pObj->pValueInterface->ValueToInteger(&argValue, &num1));
		pciGetArgByIndex( pCall, 2, &argValue );
		ThrowErr (pObj->pValueInterface->ValueToInteger(&argValue, &num2));
		pciGetArgByIndex( pCall, 3, &argValue );
		ThrowErr (pObj->pValueInterface->ValueToInteger(&argValue, &num3));

		mynum = (fp)(num1, num2, num3); // call the function in the DLL
		ThrowErr(pObj->pValueInterface->IntegerToValue(mynum, &pCall->resultValue));
		FreeLibrary(hm);
	}
	else
	{
#ifdef _DEBUG
		pObj->pMoaUtils->PrintMessage("sum3 procedure not found in the DLL\n");
#endif
		FreeLibrary(hm);
		Throw(kMoaErr_FuncNotFound);
	}

moa_catch
moa_catch_end	
moa_try_end	
}

/* ------------------------------------------------------ SetBitHandler */
MoaError TStdXtra_IMoaMmXScript::SetBitHandler(PMoaDrCallInfo pCall)
{
	MoaChar pathBuff[MAX_PATH];
	
moa_try

#ifdef _DEBUG
	ThrowErr(pObj->pMoaUtils->PrintMessage("SetBitHandler called\n"));
#endif
	GetDllPath(pathBuff, "BinaryLib.dll");
	HMODULE hm = LoadLibrary(pathBuff);
	if (hm==NULL)
	{
#ifdef _DEBUG
		pObj->pMoaUtils->PrintMessage("BinaryLib DLL not found\n");
#endif
		Throw(kMoaErr_FileNotFound);
	}
	// this sample just accesses one routine from this DLL
	typedef void (__stdcall *setbitproc) (int *Value, int bitnum, int bytes);
	setbitproc sbp = (setbitproc)GetProcAddress(hm, "SetBitD");
	if (sbp)
	{
		MoaMmValue argValue;
		MoaLong value, bitnum;
		int mynum;
		pciGetArgByIndex( pCall, 1, &argValue );
		ThrowErr (pObj->pValueInterface->ValueToInteger(&argValue, &value));
		pciGetArgByIndex( pCall, 2, &argValue );
		ThrowErr (pObj->pValueInterface->ValueToInteger(&argValue, &bitnum));
		mynum = value;
		(sbp)(&mynum, bitnum, 4);
		ThrowErr(pObj->pValueInterface->IntegerToValue(mynum, &pCall->resultValue));
		FreeLibrary(hm);
	}
	else
	{
#ifdef _DEBUG
		pObj->pMoaUtils->PrintMessage("SetBitD procedure not found in the DLL\n");
#endif
		FreeLibrary(hm);
		Throw(kMoaErr_FuncNotFound);
	}

moa_catch
moa_catch_end	
moa_try_end	
}

/* ----------------------------------------------------- GetDllPath */
MoaError TStdXtra_IMoaMmXScript::GetDllPath(PMoaChar pBuff, PMoaChar pFile)
{	
moa_try

	// find the DLL path when the DLL is located next to the Xtra
	XtraResourceCookie pSaveCookie;
	XtraResourceCookie pNewCookie;
	*pBuff = 0;
	pNewCookie = pObj->pCallback->MoaBeginUsingResources(gXtraFileRef, &pSaveCookie);
	if (pNewCookie)
	{
		int rc = GetModuleFileName(pNewCookie, pBuff, MAX_PATH);
		pObj->pCallback->MoaEndUsingResources(gXtraFileRef, pSaveCookie);
		if (rc)
		{
			int n;
			for (n=strlen(pBuff); n>0; n--)
			{
				if (pBuff[n] == '\\')
				{
					pBuff[n+1] = 0; // null terminate string after backslash
					break;
				}
			}
		}
	}
	strcat(pBuff, pFile); // add file name for the DLL

moa_catch
moa_catch_end	
moa_try_end	
}

