#!/bin/sh

# bootstrap the MinGW compilation process

echo " --- $0 ---"

export MSYSTEM=MSYS
export PATH=.:/usr/local/bin:/bin:/mingw/bin:$PATH

FSTAB="/etc/fstab"

map_fstab() {
  test $# -ne 2 && echo "map_fstab <mount_point> <drive>" && return

  echo "mapping ${2}: -> /${1}"

  if [ ! -d "/${1}" ]; then
    echo "mapping project directory .."
    
    # backup original
    if [ -f "${FSTAB}" ]; then
      cp -v "${FSTAB}" "${FSTAB}".dist	
    fi
    
    echo "${2}:/    /${1}" >>  "${FSTAB}"
  else
    echo "/${1} project directory already mapped"
  fi
}

map_fstab "pregex" "Z"


ls -l /pregex

echo "preparing depedent 3rd party packages ..."
cd /pregex/project/make_win && make

