#!/bin/sh

# build the custom pcre from source

echo " --- $0 ---"

#PRGLOC=`perl -e "print(((qq{$0}=~m{(.*)/project\b})[0] || (qx{pwd}=~m{(.*)/project\b})[0]) or die)"`
PRGLOC="`cd $(dirname $0)/../..;pwd`"
SRCLOC="${PRGLOC}/pcre-7.8"
OBJLOC="${PRGLOC}/build_win/pcre.build"
MODLOC="${PRGLOC}/project/source/pcre_custom"
DISTFILE="${PRGLOC}/project/packages/pcre-7.8.tar.bz2"

patch4pregex() {
	test $# -ne 1 && echo "patch4pregex <file>" && return
	
	if [ -a "${SRCLOC}/${1}" ]; then	
		# backup original file
		mv -v "${SRCLOC}/${1}" "${SRCLOC}/${1}".dist
		echo "-> backed up  ${SRCLOC}/${1}"
	fi
	
	cp -i "${MODLOC}/${1}" "${SRCLOC}/${1}"
	echo " patched  ${SRCLOC}/${1}"	
	
	return
}

echo "${PRGLOC}"
echo "${SRCLOC}"
echo "${OBJLOC}"
echo "${DISTFILE}"

if [ -f "${OBJLOC}/libpcre.a" ]; then
	echo "already built, exiting ..."
	exit
fi

if [ ! -d "${SRCLOC}" ]; then
	echo "extracting source file ..."
	cd "${PRGLOC}"
	tar xjf "${DISTFILE}"
fi

if [ ! -d "${OBJLOC}" ]; then
	echo "setting up build location ..."
	mkdir -pv "${OBJLOC}"
fi

cd "${OBJLOC}"

if [ -f Makefile ]; then
	make distclean
fi

patch4pregex "pcre_compile.c"


"${SRCLOC}/configure"  --build=i686-pc-mingw32\
             --enable-static=yes --enable-shared=no \
             --enable-newline-is-cr --enable-bsr-anycrlf \
             --enable-utf8 --enable-unicode-properties && \

make

mv -v "${OBJLOC}/.libs/libpcre.a" "${OBJLOC}/libpcre.a"

echo "build complete"
ls -al "${OBJLOC}/pcre.h"
ls -al "${OBJLOC}/libpcre.a"



